﻿unit Drone_Columns;

interface

uses
  {$IF DEFINED (ISFEXGUI)}
  GUI,
  {$IFEND}
  Columns, DataStorage, SysUtils;

function GetTable(const Name : string) : TSQL_Table_array;

implementation

function GetTable(const Name : string) : TSQL_Table_array;
const

 Array_Items_DRN_SKY_CSV : TSQL_Table_array = ( // SkySafe CSV
{01} (sql_col: 'DNT_Timestamp';      fex_col: 'Timestamp';      read_as: ftString;   convert_as: '';   col_type: ftDateTime;     show: True),
{02} (sql_col: 'DNT_DateTime GMT';   fex_col: 'DateTime GMT';   read_as: ftString;   convert_as: '';   col_type: ftString;       show: True),
{03} (sql_col: 'DNT_Sample Number';  fex_col: 'Sample Number';  read_as: ftString;   convert_as: '';   col_type: ftLargeInt;     show: True),
{04} (sql_col: 'DNT_Latitude';       fex_col: 'Latitude';       read_as: ftString;   convert_as: '';   col_type: ftString;       show: True),
{05} (sql_col: 'DNT_Longitude';      fex_col: 'Longitude';      read_as: ftString;   convert_as: '';   col_type: ftString;       show: True),
{06} (sql_col: 'DNT_Altitude_mASL';  fex_col: 'Altitude (m)';   read_as: ftFloat;    convert_as: '';   col_type: ftFloat;        show: True),
{07} (sql_col: 'DNT_NumSats';        fex_col: 'NumSats';        read_as: ftString;   convert_as: '';   col_type: ftString;       show: True),
{08} (sql_col: 'DNT_GPSLevel';       fex_col: 'GPSLevel';       read_as: ftString;   convert_as: '';   col_type: ftString;       show: True),
{09} (sql_col: 'DNT_RC Connected';   fex_col: 'RC Connected';   read_as: ftString;   convert_as: '';   col_type: ftString;       show: True));

    Array_Items_NULL: TSQL_Table_array = (
    (sql_col: '';
    fex_col: '';
    read_as: ftString;
    convert_as: '';
    col_type: ftString;
    show: false));    

begin
  if Name = 'DRN_SKY_CSV' then Result := Array_Items_DRN_SKY_CSV else
  begin
    Result := Array_Items_NULL;
    {$IF DEFINED (ISFEXGUI)}
    ShowMessage('Drone' + ':' + #13#10 + #13#10 + 'Did not locate artifact column layout:' + #13#10 + #13#10 + Name);
    {$IFEND}
    Progress.Log(format('%-54s %-100s', ['Error: Did not locate artifact column layout:', Name]));
  end;
end;
end.
